7log - A command line logbook
=============================
7log (c) 2019-2025 by dg7bbp

7log ist ein kommandozeilenorientiertes Logbuchprogramm für Linux. Es ist
in leichgwichtiges kleines Programm, das auch auf kleinen Displays
zum Einsatz kommen kann oder einfach per Terminal von einem Remote-Standort
zu benutzen ist.
 
Die Anfänge stammen aus dem Wunsch ein kleines Logbuchprogramm für
den Satellitenbetrieb mit gqrx_settrx [Sendeempfangs-Synchronisierung für QO100 in Funkamateur 12/2019. Aktualisiert fuer Python3] [1] zur Verfügung zu haben.
gqrx_settrx hatte ich geschrieben um für QO-100 die Sende-Empfangsfrequenzen
zu synchroniseren. Aus dem Programm heraus sollt es eine
einfache Möglichkeit geben die QSOs zu loggen und dabei die
aktuelle Frequenzen zu übernehmen.

Aus den einfachen Anfängen hat sich 7log jetzt ein wenig weiterentwickelt.

Es bietet:

  * ADIF / LOTW-Export zur Übernahme in andere Logprogramme oder für den LOTW-Upload
  * Frequenz/Mode-Abfrage vom Transceiver über das Hamlib-Interface
  * Zuordnung der Frequenz zu einer Station, so dass beim Setzen der Frequenz,
    das Call ausgegeben wird.
  * Zugriff auf qrz.com zur Abfrage des Namens der Gegenstation
    Wer einen bezahlten Account hat bekommt auch noch zusätzliche Informationen.
    Die Daten werden in der Datenbank ziwschengespeichert, dadurch werden die
    Anfragen an qrz.com reduziert.
  * Anzeige des Standorts der Gegenstation im Browser bei openstreetmap
  * Setzen der Rotorrichtung aus dem QTH-Locator
  * Unterstützung mehrere Funkgeräte
  * Erweiterung um einen einfachen eher experimentellen Contestmodus
  * Verwendung des DX-Clusters für die Abfrage der Station auf der Arbeitsfrequenz


##Installation

Das Programm basiert auf rigctld aus dem Packet hamblib. Die hamlib muss installiert und für jedes Funkgerät muss ein rigtctld Prozess mit den passenden Parametern gestartet werden.

Das 7log basiert auf Python 3. Spezielle Pakete müssen nicht installiert werden.

Nach dem entpacken mit `tar xzvf 7log_<version>.tgz` befinden sich alle benötigten
Dateien im Zielverzeichnis. 
Danach sollte ein symbolischer Link auf die 7log.py-Datei aus /usr/bin angelegt werden. Weiter Programme aus dieser Serie wie z.B. gqrx_settrx[1] erwarten 7log an der Position.
Der Link kann mit `sudo ln -s <Pfad zu 7log.py> /usr/bin/7log` angelegt werden.

Im entpackten Verzeichnis befindet sich im Unterverzeichnis `config_template` Dateien für die Präfixdatenbank und die Relaislisten. Sie können für erste Versuche in das lokale benutzerabhängige Konfigurationverzeichnis `~/.config/7log/` kopiert werden. Es ist zu empfehlen sie im Anschluss aus den später genannten
Internetquellen zu aktualisieren.

Zuerst sind die notwendigen Standardeinstellungen über 7log --set vorzunehmen

```
    7log --set callsign <your call>
    7log --set operator <operator call may be empty>
    7log --set locator <your locator>
    7log --set lastqsos <number> of qso to show for already worked stations
    7log --set qrzlogin <your qrz.com login> (Optional)
    7log --set qrzpassword <your qrz password> 
           (Es wird unverschlüsselt auf der Platte gespeichert!) (Optional)
    7log --set defaultrig: <Name der verwendeten Stationsbeschreibung
                              (siehe rigdesc.json)>
    7log --set dxclusterhost <hostnam des telnet dxclusters> (Optional)
    7log --set dxclusterport <port des telnet clusters> (Optional)
    7log --set dxclustercall <call /login des clusters> (Optional)
    7log --set cloudlogurl <baseurl of cloudlog> (Optional)
    7log --set cloudlogkey <api key from cloudlog> (Optional)
    7log --set cloudlogstationid <station id for cloudlogupload> (Optional)
```
                               
Optional kann mit


```shell
7log --set database <Pfad zur sqlite Datenbank>
```

ein anderer Speicherort für die Datenbank angegeben werden. Der Standard für
den Speicherort ist in `~/.config/7log/7log.sqlite`


Danach kann ein QSO gelogged werden.
Jedes QSO beginnt mit dem Erkennen eines neuen Rufzeichens. Dieses schließt
das Loggen des vorherigen QSOs ab, wenn alle benötigen Parameter vorhanden sind.
D.h. es muss zumindest ein Call, die Frequenz und die Betriebsart (mode) angegeben sein.
Wenn konfiguriert werden Frequenz und Mode vom Funkgerät abgefragt.
Erfolgt keien Angabe der von Frequenz und Mode werden sie vom vorherigen
QSO übernommen. Dieses gilt auch für den Repeater solange sich das
Band nicht geändert hat.

Das Verhalten im Contestmodus unterscheidet sich hier und ist später
beschrieben.

Datumsangaben müssen im ISO-Format 2021-12-31 angeben werden.
Zeiten im Format `10:33[:ss]` in UTC angegeben werden.

z.B:

    7log dl2aa      // Startet das QSO mit dl2aa
    7log 57 jo32aa  // Ergänzt das QSO mit dl2aa um den erhaltenen Report
    7log Maik SSB 14.3MHz s:56  // Ergänzt das QSO
    				  // um Frequenz und Betriebsart und gesendeten Report.
    7log qslreq     // Vermerkt, dass dl1aa eine QSL-Karte möchte
    7log qslout     // Setzt, das Flag, dass die QSL-Karte ausgefüllt ist.
    7log dg9zz      // Beginnt das neue QSO und speichert das QSO mit dl2aa
    7log -s         // speichert das letzte qso als komplett
                    // ohne auf ein neues call zu warten.

    7log --cancel // löscht das letzte begonnende
                    aber noch nicht abgeschlossen QSO
    7log --correct // korrigiert das Call des letzen offenen QSOs

Wird kein RST angegeben, ist 59(9) die Standardvorbelegung.
Es können auch alle Parameter für ein QSO mit einem Aufruf angegeben werden. Zu empfehlen ist
mit Cursor Up in der bash einfach das letzte Kommando erneut anzuzeihen und dieses
um die gewünschten Werte zu erweitern. Das ist in der Regel schneller als 7log erneut
einzugeben.

     
Ist der Transceiver über die Hamlib angeschlossen oder belegt das
aufrufende Programm die Frequenz über eine Umgebungsvariable vor (z.B.von gqrx_settrx),
brauchen diese Werte nicht eingeben zu werden.
Sonst wird die Betriebsart und die Frequenz vom vorherigem QSO übernommen und braucht nur
bei einem Wechsel des Bandes oder der Betriebsart neu eingegeben zu werden.

Ist der Transceiver über die CAT/CI--Schnittstelle mit dem Computer verbunden und sind die
qrz.com-Zugungsdaten gesetzt erfolgt der Eintrag eines QSOs in der Regel mit nur einem
Aufruf

```
    dg7bbp@webb:~$ 7log dl2ab

    QRZ: Name: Daniel Wendt-Froehlich
    2022-02-20|11:52|DL2AB   |FM  |DB0FT|70cm |59  |59  |Daniel  | | | ||
    Last QSOs:
    2021-05-22|20:01| DL2AB  |70cm |Daniel,
    2021-03-11|20:00| DL2AB  |2m   |Daniel,
    2021-02-09|19:19| DL2AB  |2m   |Daniel,

```
Die restliche Werte werden automatisch vom Funkgerät, qrz.com und aus der Relaisdatenbank
übernommen.


Normalerweise erkennt 7log die Eingaben anhand von regulären Ausdrücken. Diese funktionieren
aber bei einigen Sonderrufzeichen wie ON75AB nicht. Dann kann das Call über `--call <call>` oder per `c:<call>` angegeben werden.


Alle nicht erkannten Parameter werden in das Info/Kommetarfeld übernommen. Diese Werte können auch direkt mit

    7log --info "DOK:I04, QTH: Las Palmas"

angegeben werden.

Da bei der Angabe von -- Parametern, ist die Reihenfolge nicht mehr beliebig ist,
besteht auch die Möglichkeit für bestimmte Felder diese durch eine Vorsatz genauer anzugeben. Das ist z.B. sinnvoll,
wenn ich ein FT8 QSO loggen, will bei dem der Rapport nicht rst ist.

```code
  7log  c:on75xab s:-17dbm FT8  n:Paul benutzt einen Adalm Pluto
```
Dafür stehen folgen Kürzel für Verfügung:

 * :c Call
 * :n Name
 * :s Gesendeter Rapport
 * :r Repeater

Bei einem längeren QSO kann die Endzeit mit

```code
  7log --finish now
```
oder durch Angabe einer Zeit angegeben werden.

Ein nachträgliches Editieren ist durch den `--update` Befehl mit Angabe
der internen QSO-Nummber möglich. Update kann mit weiteren Parametern
ergänzt werden, die dann in den Datensatz übernommen werden.


```code
  7log --list <Datum Beginn> <Datum Ende>
  7log --last [<Anzahl>]
 ```

gibt die QSO auf der Standardausgabe aus.

bei der Verwendung des nicht Standard-Funkgeräts kann für ein QSO das
verwendeten Funkgerät angegeben werden.

```code
  7log --rig <rigname>
```
  
Dieses  ermöglicht die Angabe der verwendeten Station im Logfile und wird benötigt
um z.B. einen speziellen Rotor anzusprechen.
  
Bei --update in Kombination mit --rig wird nur der angegeben
Parameter in das Datenbankfeld übernommen. Es findet keine
Anpassung des Antennenattributes statt.


Als weitere Funktion besteht die Möglichkeit den Standort
einer Station aus dem Locator im Browser über openstreetmap anzuzeigen.
Dazu muss ein Firefox oder ein chromium installiert sein.
Starten Sie den Browser bevor sie diese Funktion verwenden.

```shell
    7log --map <locator>
```

Verwendung verschiedener Session
================================
Möchte ich QSOs für einen Contest erfassen und gleichzeitig ein QSOs auf
einer Ortsfrequenz loggen besteht die Möglichkeit in verschiedenen
Session zu arbeiten.
Dazu verwendet die Software eine Session ID. Diese ID wird in der folgenden
Reihenfolge ermittelt.

   1. Der Wert aus der Umgebungsvariable `7LOG_SESSION_ID`
   
   2. Die in der Konfiguration mit `7log set config_id <id>` angegeben ID.
   
   3. Der Benutzername aus der Umgebungsvariable `USER`
 
   4. Der Benutzername aus der Umgebungsvariable `USERNAME` (Windows)
 
 


Zuordnung der Frequenz zu einer Station
=======================================

    7log --mark df0mu  // vermerkt, dass df0mu auf
                       //  der aktuellen Frequenz
                       //  dauernd CQ ruft (z.B: 432.190 MHz)
    7log --mark ol3c   // vermerkt, dass ol3c diese Frequenz benutzt (z.B. 432.210 Mhz)
    7log --mark ol3c   // vermerkt bzw. aktualisiert, die Frequenz für ol3c (z.B. auf 432.220)

Es wird jeweils eine Frequenz pro Station und Band vermerkt.

    7log --stations

fragt für die aktuelle Frequenz des TRX ab welche Stationen dort
vermerkt, sind, so dass nicht auf die Nennung des Rufzeichens
gewartet werden muss.

Wird der TRX auf 432.210 gestellt, erfolgt die Ausgabe der Station und der erfassten Antennenrichtung, sowie der Zeitpunkt an dem der Marker gesetzt wurde.

Ausgabe :

    432.220 OL3C 150° 13:30

Stationsdaten von qrz.com
=========================

Wird beim Loggen kein Namen angegeben, versucht 7log den Namen über qrz.com
zu ermitteln. Die Information wird in der Datenbank abgelegt,
so dass bei einem weiteren QSO nicht erneut bei
qrz.com angefragt wird.

Mit 

	7log --qrz <callsign>

kann die Information auf dem Terminal ausgegeben werden.

	7log --qrz dg7bbp

	qrz.com information:
	     fname: Jens
	   country: Germany
	      name: Rosebrock
	      call: DG7BBP

Mit einem bezahlten Accout bei qrz.com gibt es mehr Daten, sonst
werden nur die einfachen Daten ausgegeben.

Länderinformationen CQ und ITU-Zone
===================================
Die CQ und ITU Zone der Gegenstation werden in die Datenbank unter
dst_cqzone und dst_ituzone eingetragen. Dazu werden die Datenbanken
von cqrlog AreaOK1RR.tbl und Contry.tab verwendet. Diese müssen
in das Konfigurationsverzeichnis von 7log kopiert werden. 
Über `7log --area <call>` kann die Information für ein beliebies Call abgefragt werden. Die Ausgabe ermittelt auch den Ländernamen zu dem Call. Sollte das Call einen Präfix haben, wie z.B. PA/DG7BBP, dann werden die Länderinformationen zu dem Präfix ausgegeben.
Aktuelle Daten werden von durch [OK2CGR][4] bereit gestellt. 
Die Daten können mit mit `7log --fetchareadata` von der genannten Seite aktualisiert werden.

DX-Cluster Informationen
========================
Mit `7log --grabcluster` können die Daten eines
Telnet DX-Clusters in die Datenbank übernommen werden. In der Datenbank werden die DX-Spots der letzten Stunde gespeichert. Dazu müssen in der Konfugartion hostname, port und login callsign
angegeben sein.

Auf diese Daten kann mit `7log --who [<frequency>] [--rig <rigname>]` zugegriffen. Für die aktuelle
Frequenz (+/- 500Hz) des Transceivers oder der angegebenen Frequenz werden die gespotten Stationen ausgegeben.

Die gesammelten Informationen der letzten Stunde lassen sich pro
Band mit  `7log --dxcluster <band>` abfragen. Die Bandangabe
muss dabei z.b: in der Form 20m oder 70cm erfolgen.

Ein einfaches wechseln auf die Frequenz einer DX-Station erlaubt der
Befehl `7log --gotocall <call> <band>`. Wobei für `<band>` ein Punkt für das aktuelle Band eine Banbdbezeichnung wie 20m oder ein A für
ein beliebiges Band angegeben werden kann. 

Um bei einem QSO mit einer Station aus einem DX-Cluster das Rufzeichen nicht eingeben zu müssen, kann dieses mit
`7log --cc <Weitere Parameter>` übernommen werden. Dieses entspricht der Angabe von `--call`.

Das aktuelle QSO kann mit `7log --spotqso "<comment>"` an den DX-Cluster
gesendet werden. Dabei werden Frequenz und Rufzeichen der Gegenstation uebernommen.
Läuft der grabcluster-Prozess, so erfolgt das senden über diese Verbindung. Sonst
wird eine Verbindung direkt aus der aufgerufenen Instanz erstellt die
Verbindnung zum Cluster sofort wieder abgebaut. 

Nachträgliches Erfassen von QSOs
================================
QSO können auch die Angabe von Zeit und Datum später erfasst werden,
z.b. weil man nur ein Papierlogbuch bei einer SOTA-Aktivität dabei hatte.
Hier sollte vorher der eigene Standort und ggf. das eigene callsign z.B. um  /P mit den folgenden Befehlen angepasst werden.

    7log --set locator
    7log --set callsign dg7bbp/p

Im Anschluss können die QSOs erfasst werden. Hier gelten
die normalen Eingaberegeln. Die Reihenfolge darf beliebig
gewählt werden und es wird versucht anhand des Inhalts der einzelnen
Parameter die Daten dem richtigen Attribut zuzuordnen.

    7log  2020-10-30 10:33 14.2MHz 57 dl1pt SSB Michael


Repeater
========

7log unterstuetzt Repeater-Datenbanken in Form der von [DARC OV A23][3].
für ICOM-Transceiver bereitgestellten Dateien.
Diese Dateien müssen in `./config/7log/repeater` kopiert werden.
Achten sie darauf, dass jeweils nur die aktuelle Version der DV und FM-Liste eingespielt werden.

Ist eine Liste vorhanden kann mit

```code
  7log --repeatersearch <Locator oder Frequenz> 
```
eine nach Entfernung sortierte Liste der Umsetzer ausgegeben werden.
Die Eingabe der Frequenz muss in der gewohnten Form  mit mit . als Dezimalpunkt
und der Einheit erfolgen. Z.B. 438.875MHz.

Wird die Frequenz angeben wird als Ausgangspunkt der Stationslocator verwendet.
Bei Eingabe des Locators werden alle Repeater in der Nähe des eingegeben Locators
ausgegeben. Der maximale Radius sind hier 120km.

Beim Loggen eines QSOs wird auf Frequenzen ` > 29Mhz` versucht das Feld für den Repeater
automatisch auszufüllen, wenn der Repeater nicht mit r: oder --repeater angegeben wird.
Dazu wird der nächste auf der angegeben Frequenz liegende Repeater verwendet.

Ist in der Repeaterliste kein Treffer vorhanden wird der Repeater vom vorherigen
nur dann übernommen, wenn sich das Band nicht geändert hat. Dieses erspart
beim Betrieb über einen Satelliten oder Lineartransponder die dauernde Eingabe
der Umsetzers. Satelliten müssen in AMSAT-Bezeichnung eingeben werden z.B.: QO-100, damit bei
der ADIF-Ausgabe die Felder passend belegt werden.

Die manuelle Eingabe eines Umsetzers erfolgt mit -r DB0WU, --repeater QO-100 oder r:DB0HFT.

Repeater-Namen, die eine Satelliten-Namen wie AO-91 oder QO-100 entsprechen werden 
beim ADIF-Export als Satelliten QSO betrachtet.

Rotorsteuerung
==============
Ist ein Rotor definiert kann mit

```code
  7log --rotor <Locator|Grad>
```
der Rotor in die gewünschte Richung per Angabe des Locators oder der Richtung in Grad gedreht werden.

ADIF-Export
===========
Die gespeicherten QSO-Daten können mit

    7log --adif <from date> <to date>  <filename> 

exportiert werden.

LOTW scheint bestimmte Spezifikationen anders zu interpretieren,
daher gibt es für LOTW eine eigenen Export mit:

    7log --lotw <from date> <to date>  <filename> 

DARC QSL-Service
================
QSOs können für den DARC-QSL-Server mit

```
    7log --qslexport <callsign> <locator> <destination path>
```

 exportiert werden. Nach dem Upload der ADIF-Datei müssen die QSOs mit
 Export werden alle QSOs bei denen qslreq gesetzt ist und qslout noch nicht gefüllt.

 ```
 7log --qslsend <exportnummer>
 ```

 als exportiert gekennzeichnet werden.
 Erst dieses Kommando setzt qslout für die vorher exportierten QSOs.
 Damit werden die QSOs im nächsten durchlauf nicht mehr exportiert.

Eingehende QSL-Karten verwalten
===============================

```
7log --qslrecord  <pse|tnx> <call> [<date>]...
```

Mit qslrecord können eingehende QSL-verwaltet werden. Es muss angegeben werden ob die Gegenstation
eine QSL möchte oder bereits eine erhalten hat.
Im Anschluss muss das Rufzeichen und optional das Datum und weitere Suchbedingungen für das QSO angegegen werden.
Gibt es für die Bedinung mehr als ein QSO muss man das gewünschte QSO mit Eingabe der QSO-Nummer auswählen.
Ist pse angegeben, wird geprüft ob noch keine Karte versendet wurde. In dem Fall, wird qslreq für das QSO gesetzt damit
kann dieses QSO beim nächsten `--qslexport` mit übergeben werden.


Cloudlog /Wavelog export
========================
QSOs können nach Cloudlog exportiert werden. Dazu werden die
Adif-Daten mit der QSO API von cloudlog übertragen.
dazu müssen die passenden cloudlog- Klonfigurationseinstellungen
vorgenommen werden.
Cloudlog besitzt eine Überprüfung für doppelte QSOs, daher
kann ein QSO auch in verschiedenen Übertragungen enthalten
sein. Ein Upload erfolgt mit.

    7log --cloudlog <config> <from date> <to date>

Für die über 7log --set gesetzt Konfigutration muss default als config
angegeben werden.
Wenn die Daten in weitere Cloud/Wavelog instanzen übertragen werden sollen,
können diese über eine cloudlog.json-Datei im 7log-Config-Verzeichnis
definiert werden.
 
 ```code
 {"darc":
 	{"url": "https://log.darc.dex",
	 "stationid": "<ID aus der Cloudloginstanz>",
	 "key": "<api key>"},
  "anothersystem":
  	{"url": "https://anothersystem.xyz.de/cloudlog",
	 "stationid": "<ID aus der Cloudloginstanz>",
	  "key": "<api key>"}
   } 
 ```

Import
======
7log kann adif-Daten und Daten aus einer
zweiten 7log Instanz importieren.Befehle hierfür sind:

```code
   --adifimport ADIFIMPORT
     Imports adif file into database
   --dbimport DBIMPORT DBIMPORT
         Imports qsos from 2nd 7log db.
            Args: dbfile, startdate

```

Stationskonfiguration
=====================

Die Stationsbeschreibung erlaubt unterschiedliche Antennen für
verschiedene Bänder, so dass in der QSL-Karte nur die 2m Antennen, aber
nicht alle KW-Antennen für ein 2m QSO aufgeführt sind.  Darüber hinaus
sind in der Konfigurationsdatei die Adressen für die Trasnceiver und
Rotorsteuerung über die hamblib-Prozesse rigctld bzw. rotctld einzutragen.

Die Definition erfolgt in der rigdesc.json-Datei im Konfigurationsverzeichnis.
  

Beispiel einer rigdesc.json:

```json
	{"ic705home": {"rigdesc": "IC 705 controlled by Raspberry PI",
	               "antenna": {"default": "Dipol 2 * 7m with BX 1200 tuner",
	                           "2m": "X-5000",
	                           "70cm": "X-5000"},
	               "rigctldhost": "localhost:4532",
	               "rotctldhost": "localhost:4533",
	               "freqoffset": 0.0},
	
	"QO100": {"rigdesc": "IC910 with Raspi and GQRX Upconverter: MKUUP2424B(4W out) Downconverter: AMSAT DL",
	          "antenna": {"default": "1m offset dish 4 turns helix"},
	          "rigctldhost": "",
	          "freqoffset": 0.0},
	"ic705portable": {"rigdesc": "IC 705 controlled by Raspberry PI",
	                  "antenna": {"default": "Triple leg for 20m -10m",
	                          "40m": "Groundplane",
	                          "80m": "Groundplane"},
	                  "rigctldhost": "localhost:4532",
	                  "freqoffset": 0.0},
	"23cm": {"rigdesc": "IC 705 + db6nt 13mk2 + PA 40W",
	                    "antenna": {"default": "Flexa FX2317"},
	                    "rigctldhost": "localhost:4532",
	                    "rotctldhost": "localhost:4533",
	                    "freqoffset": 1152.0e6}
    }

```


Contest-Modus
=============
Im Contest-Modus muss die Eingabe eines QSOs immer in einer kompletten Zeile erfolgen.
Sobald alle notwendigen Eingaben vorhanden sind, wird das QSO gespeichert
und die nächste laufenden Nummer ausgegeben.

Das Loggen erfolgt wie in folgendem Beispiel

    7log df0mu 57123 JO32PC
    Bearing: 225 Distance : 150
    QRZ: Name: Contest Gruppe Schöppinger Berg e.V.
    Contest: vuhf2021-05
    2021-05-23|14:57|DF0MU   |SSB |      |2m   |59007|57123|Contest Gruppe| | | |
    Next contest number: 008

oder bei nicht vollständiger Eingabe:

    7log dl0gth 59107
    QRZ: Name: Club Station
    Contest: vuhf2021-05
    Contest QSO not complete. Missing dst_locator

Für die Verwendung des Contestmodus muss zuerst ein Contest angelegt werden.
Dieses erfolgt über

    7log --contestnew <template> <contestname>

template ist eine Contestvorlage.


Es gibt Standard-Contestvorlagen, diese werden aus dem Programmverzeichnis aus der Datei contest.json gelesen.

Weitere, selbstdefinierte Contestvorlagen können in 

~/.config/7log/contesttemplates.json abgelegt werden. Die die dort definierten Contestvorlagen überschreiben ggf. die Vorlage aus dem Programmverzeichnis, wenn sie unter demselben Namen abgelegt sind.

Contest-Vorlagen werden in einer JSON-Datei definiert. 
Die Standardconteste sind wie folgt definiert:

```json
	{"DARC-XMAS-DL": {"number_per_band": false,
 	                  "number_scheme": "$(DOK)",
                      "required_attrs": ["src_call", 
	                                    "dst_call",
	                                    "band",
	                                    "rst_send",
	                                    "rst_received"],
	                  "unique_station_attrs": ["src_call",
	                                          "dst_call",
	                                          "band"]},
	 "DARC-XMAS-FOREIGN": {"number_per_band":false,
	                       "number_scheme": "$(NUM)",
	                       "required_attrs": ["src_call",
	                                          "dst_call",
	                                          "band",
	                                          "rst_send",
	                                          "rst_received"],
	                       "unique_station_attrs": ["src_call",
	                                                "dst_call",
	                                                "band"]},
	 "DARC-10M-DL": {"number_per_band": false,
	                 "number_scheme": "$(NUM)$(DOK)",
	                 "required_attrs": ["src_call",
	                                    "dst_call",
	                                    "band",
	                                    "rst_send",
	                                    "rst_received"],
	                 "unique_station_attrs": ["src_call",
	                                          "dst_call",
	                                          "band"]},
	 "DARC-10M-FOREIGN": {"number_per_band": false,
	                      "number_scheme": "$(NUM)",
	                      "required_attrs": ["src_call",
	                                         "dst_call",
	                                         "band",
	                                         "rst_send",
	                                         "rst_received"],
	                      "unique_station_attrs": ["src_call",
	                                               "dst_call",
	                                               "band"]},
	 "IARU-Region1-Fielday": {"number_per_band": false,
	                       "number_scheme": "$(NUM)",
	                       "required_attrs": ["src_call",
	                                          "dst_call",
	                                          "band",
	                                          "rst_send",
	                                          "rst_received"],
	                       "unique_station_attrs": ["src_call",
	                                                "dst_call",
	                                                "band"]},
	 "DARC-VUHF": {"number_per_band": true,
	               "number_scheme": "$(NUM)",
	               "required_attrs": ["src_call",
	                                  "dst_call",
	                                  "band",
	                                  "rst_send",
	                                  "rst_received",
	                                  "dst_locator",
	                                  "src_locator"],
	               "unique_station_attrs": ["src_call",
	                                        "dst_call",
	                                        "band"]}
	}
```

Alle bekannten Conteste und die Liste der Vorlagen können mit

    7log --contestlist

abgerufen werden. 

Eine besondere Bedeutung haben die `$(<var>)`-Felder. $(NUM) wird durch
die laufende Nummer ersetzt. Andere Variablen werden als statisch für 
den Contest angesehen und bei der Neuanlage des Contests abgefragt, wie z.B.
$(DOK).

Aktivieren eines Contests erfolgt mit

    7log --contestset <contestname>

Diese schaltet die aktuelle Session in den Contestmode. Wenn der
Contestmode wieder aufgehoben werden soll, dann kann dieses mit dem einem
leeren Contestname ""
erfolgen.

Die Abfrage der aktuellen laufenden Nummern erfolgt mit 

    7log --contestinfo <contestname>
    
Dabei werden nur die Nummern für die Bänder ausgegeben auf den schon ein QSO geführt
wurde.

Zurzeit wird nur ein Contestexport im EDI Format für V/U/SHF-Conteste unterstützt.

```code
  7log --edi <contestname> <edi template> <file prefix>
```
edi template ist eine Datei mit den Basisdaten für den Auswerter des Contest enthalten.
Darin sind Platzhalter für bestimmte Werte enthalten, die durch 7log ersetzt
werden. Es bietet sich an die Namen z.b. nach Standort und CALL anzulegen. z.B. `DG7BPP_JO43KB.editmpl`

```code

[WinContest]
This data was exported using 7log
Call=$(CALL)
Locator=$(LOCATOR)
Band=$(MHZ)


[REG1TEST;1] 
TName=IARU VHF-CONTEST
TDate=$(BEGINDATE);$(ENDDATE)
PCall=$(CALL)
PWWLo=$(LOCATOR)
PExch=
PAdr1=Kleingarten Hasenpromenade
PAdr2=28307 Bremen
PSect=Single
PBand=($MHZ)
PClub=I04
RName=Jens Rosebrock
RCall=DG7BBP
RAdr1=XXXXXX
RAdr2=
RPoCo=28307
RCity=Bremen
RCoun=Bundesrepulik Deutschland
RPhon=
RHBBS=
MOpe1=
MOpe2=
STXEq=$(RIG)IC 910H
SPowe=70
SRXEq=$(RIG)IC 910H
SAnte=$(ANTENNA) Flexa 7023
SAntH=5;12
CQSOs=$(QSOCNT);1
CQSOP=$(QSOPOINTS);5525
CWWLs=$(LOCATORCNT);0;1
CWWLB=0
CExcs=0;0;1
CExcB=
CDXCs=5;0;1
CDXCB=0
CToSc=5525
CODXC=$(ODXCALL);$(ODXLOC);$(ODXPOINTS)
[Remarks]
[QSORecords;$(QSOCNT)]

```

file_prefix wird verwendet um die erzeugten Dateinamen zu bilden.
Der Dateinamen setzt sich aus `<file_prefix>_<band>.edi` zusammen. Es wird für jedes
Band des Contests eine eigene Datei erzeugt.


Technische Hinweise
===================
7log speichert alle Daten in ~/.config/7log/

Die Daten sind in einer sqlite3-Datenbank gespeichert. Eigene Auswertungen
können so einfach vorgenommen werden. 


Für die Übergabe der Frequenz von einem aufrufenden Porgramm können die Umgebungsvariablen
DG7BBP_LOG_QRG_RX und DG7BBP_LOG_QRG gesetzt werden.


Zusammearbeit mit anderen Programmen
====================================
7log wird auch von [7ft8alarm.py][2] unterstützt und ermöglich hier WSJTX das direkte loggen
in die 7log-Datenbank.

7log kann aus gqrx_settrx [Sendeempfangs-Synchronisierung für QO100 in Funkamateur 12/2019. Aktualisiert fuer Python3][1] heraus aufgerufen werden. Es werden die Up/Down-Link-Frequnzen
an 7log übergeben.


## Rechtliches
Copyright Jens Rosebrock, 2019-2023

Das Programm darf von Funkamateuren für den privaten Einsatz frei verwendet werden.
Eine kommerzielle Nutzung ist ausgeschlossen. 

Die Verwendung des Programms erfolgt auf eigene Gefahr. Der Autor übernimmt keine Haftung für irgendwelche Schäden, die durch die Verwendung des Programms entstehen.


[1]: https://dg7bbp.darc.de/software.html#gqrxsetrx

[2]: https://dg7bbp.darc.de/software.html#ft8alarm

[3]: https://www.a23-wertheim.de/downloads/d-star/repeater-listen

[4]: http://www.ok2cqr.com/linux/cqrlog/ctyfiles/cqrlog-cty.tar.gz
