"""
/log: cmd line logbook
written by dg7bbp

Initially developed for gqrx_set_trx.py

(c) 2019-2024, dg7bbp, Jens Rosebrock

cloudlog upload interface
"""

import requests
import sys

# see https://github.com/magicbug/Cloudlog/wiki/API#apiqso


def cloudlog_send_adif(url, api_key, station_id, adif_list):
    """
    param url: cloudlog base url
    param api_key: cloudlog api key
    param station_id: str cloudlog statiom id
    param adif_list: list of adif lines (strings)_
    """
    post_url = url
    if not url.endswith("/"):
        post_url += "/"
    post_url += "index.php/api/qso/"
    adif_recs = "\n".join(adif_list)
    data = {
        "key": api_key,
        "station_profile_id": station_id,
        "type": "adif",
        "string": adif_recs,
    }
    r = requests.post(post_url, json=data)
    if r.status_code != 201:
        print(r.text, file=sys.stderr)
        return False
    return True
