#! /usr/bin/env python3
# -*- coding: utf-8 -*-

"""
Base Class for contest addons

part of 7log: cmd line logbook
written by dg7bbp

Initially developed for gqrx_set_trx.py

(c) 2019-2023, dg7bbp, Jens Rosebrock
"""

from enum import Enum


class InvalidExchaneException(Exception):
    pass


class ContestBase(object):
    """
    Base class for all Contest
    """

    class MultiEnum(Enum):
        _no = 0

    unique_station_attrs = []
    required_attrs = []

    def __init__(self, db):
        self.db = db

    def export_cabrillo(self):
        """
        Exports contest data to contest specific cabrillo
        """
        pass

    def is_multi(self, call, exchange, max_record=None):
        """
        :param call: str with call
        :param exchange current exchange (i.E DOK)
        :param max_record: Int. Max records id to consider.
          (use for recalculation)
        returns a set of MultiEnums. if given call, exchange is a new multi
        """
        return set()

    def split_rst(self, db_values):
        """
        splits rst and exchange if exchange is added rst
        or get locator als exchange depending on contest.
        format exchange if necessary. i.e. 1 to 001
        return tuple rst and exchange
        raises InvalidExchaneException
        """
        pass

    def own_exchange(self):
        """
        : returns own exchange
        """
        pass
